# macOS Build Instructions

## Building on GitHub Actions

The macOS build is automated via GitHub Actions. To trigger a new build:

1. Push changes to `main` branch, or
2. Go to GitHub Actions → "Build macOS (arm64)" → "Run workflow"

## Download the Build

Run the download script:
```powershell
powershell -ExecutionPolicy Bypass -File scripts/download-macos-build.ps1
```

Update `$RunId` in the script with the workflow run number from GitHub Actions.

## Build Output

- **Filename**: `MiBa-Video-Manager-<version>.zip` (e.g., `MiBa-Video-Manager-1.1.7.zip`)
- **Location**: `dist/` folder
- **Architecture**: arm64 (Apple Silicon)

## Running the App

The app is unsigned but ad-hoc signed, so:

1. Extract the ZIP
2. Double-click the `.app`
3. If warned about unidentified developer:
   - Right-click → "Open" → "Open" in dialog
   - Or go to System Settings → Privacy & Security → "Open Anyway"

## Troubleshooting

### App won't open
Run in Terminal:
```bash
xattr -cr "/path/to/MiBa Video Manager.app"
```

### Rebuild icons locally
```bash
npm run generate:icons
```

### Build locally on Mac
```bash
npm run build:mac:arm64
```
